/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;
import net.pavocado.exoticbirds.entity.EntityAbstractBird;
import net.pavocado.exoticbirds.tileentity.TileEntityBirdcage;

public class PacketBirdcageSound {
    private final BlockPos cagePosition;

    public PacketBirdcageSound(BlockPos cagePosition) {
        this.cagePosition = cagePosition;
    }

    public static void encode(PacketBirdcageSound message, PacketBuffer buffer) {
        buffer.func_179255_a(message.cagePosition);
    }

    public static PacketBirdcageSound decode(PacketBuffer buffer) {
        return new PacketBirdcageSound(buffer.func_179259_c());
    }

    public static void handle(PacketBirdcageSound packet, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> PacketBirdcageSound.handleOnClient(packet)));
        contextSupplier.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleOnClient(PacketBirdcageSound packet) {
        SoundEvent birdSound;
        TileEntityBirdcage tileentitybirdcage;
        Entity entityBird;
        TileEntity tileEntity;
        BlockPos pos;
        World world;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && (world = player.func_130014_f_()).func_175667_e(pos = packet.cagePosition) && (tileEntity = world.func_175625_s(pos)) instanceof TileEntityBirdcage && (entityBird = (tileentitybirdcage = (TileEntityBirdcage)tileEntity).getBirdcageLogic().getCachedEntity()) instanceof EntityAbstractBird && (birdSound = ((EntityAbstractBird)entityBird).getBirdcageSound()) != null) {
            world.func_184133_a((PlayerEntity)player, pos, birdSound, SoundCategory.AMBIENT, 0.8f, ((EntityAbstractBird)entityBird).getBirdcagePitch());
            world.func_195594_a((IParticleData)ParticleTypes.field_197597_H, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.2, (double)pos.func_177952_p() + 0.5, (double)world.field_73012_v.nextInt(24) / 24.0, 0.0, 0.0);
        }
    }
}

